/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.rituals;

import java.awt.Point;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import ru.betterend.blocks.entities.InfusionPedestalEntity;
import ru.betterend.blocks.entities.PedestalBlockEntity;
import ru.betterend.particle.InfusionParticleType;
import ru.betterend.recipe.builders.InfusionRecipe;

public class InfusionRitual
implements class_1263 {
    private static final Point[] PEDESTALS_MAP = new Point[]{new Point(0, 3), new Point(2, 2), new Point(3, 0), new Point(2, -2), new Point(0, -3), new Point(-2, -2), new Point(-3, 0), new Point(-2, 2)};
    private class_1937 world;
    private class_2338 worldPos;
    private InfusionRecipe activeRecipe;
    private boolean isDirty = false;
    private boolean hasRecipe = false;
    private int progress = 0;
    private int time = 0;
    private final PedestalBlockEntity[] catalysts = new PedestalBlockEntity[8];
    private final InfusionPedestalEntity input;

    public InfusionRitual(InfusionPedestalEntity pedestal, class_1937 world, class_2338 pos) {
        this.input = pedestal;
        this.world = world;
        this.worldPos = pos;
        this.configure();
    }

    public void configure() {
        if (this.world == null || this.worldPos == null) {
            return;
        }
        for (int i = 0; i < this.catalysts.length; ++i) {
            Point point = PEDESTALS_MAP[i];
            class_2338.class_2339 checkPos = this.worldPos.method_25503().method_10104(class_2350.field_11034, point.x).method_10104(class_2350.field_11043, point.y);
            class_2586 catalystEntity = this.world.method_8321((class_2338)checkPos);
            this.catalysts[i] = catalystEntity instanceof PedestalBlockEntity ? (PedestalBlockEntity)catalystEntity : null;
        }
    }

    public boolean checkRecipe() {
        if (!this.isValid()) {
            return false;
        }
        InfusionRecipe recipe = this.world.method_8433().method_8132(InfusionRecipe.TYPE, (class_1263)this, this.world).orElse(null);
        if (this.hasRecipe()) {
            if (recipe == null) {
                this.reset();
                return false;
            }
            if (this.activeRecipe == null || recipe.getInfusionTime() != this.time) {
                this.updateRecipe(recipe);
            }
            return true;
        }
        if (recipe != null) {
            this.updateRecipe(recipe);
            return true;
        }
        return false;
    }

    private void updateRecipe(InfusionRecipe recipe) {
        this.activeRecipe = recipe;
        this.hasRecipe = true;
        this.resetTimer();
        this.method_5431();
    }

    private void resetTimer() {
        this.time = this.activeRecipe != null ? this.activeRecipe.getInfusionTime() : 0;
        this.progress = 0;
    }

    public void reset() {
        this.activeRecipe = null;
        this.hasRecipe = false;
        this.resetTimer();
        this.method_5431();
    }

    public void tick() {
        if (this.isDirty) {
            this.configure();
            this.isDirty = false;
        }
        if (!this.checkRecipe()) {
            return;
        }
        ++this.progress;
        if (this.progress == this.time) {
            this.method_5448();
            this.input.method_5447(0, this.activeRecipe.assemble(this));
            this.reset();
        } else if (this.world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)this.world;
            class_2338 target = this.worldPos.method_10084();
            double tx = (double)target.method_10263() + 0.5;
            double ty = (double)target.method_10264() + 0.5;
            double tz = (double)target.method_10260() + 0.5;
            for (PedestalBlockEntity catalyst : this.catalysts) {
                class_1799 stack = catalyst.method_5438(0);
                if (stack.method_7960()) continue;
                class_2338 start = catalyst.method_11016();
                double sx = (double)start.method_10263() + 0.5;
                double sy = (double)start.method_10264() + 1.25;
                double sz = (double)start.method_10260() + 0.5;
                serverLevel.method_14199((class_2394)new InfusionParticleType(stack), sx, sy, sz, 0, tx - sx, ty - sy, tz - sz, 0.5);
            }
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.isValid();
    }

    public boolean isValid() {
        if (this.world == null || this.worldPos == null || this.input == null) {
            return false;
        }
        return Arrays.stream(this.catalysts).noneMatch(Objects::isNull);
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public void setLocation(class_1937 world, class_2338 pos) {
        this.world = world;
        this.worldPos = pos;
        this.isDirty = true;
    }

    public void method_5448() {
        if (!this.isValid()) {
            return;
        }
        this.input.method_5448();
        Arrays.stream(this.catalysts).forEach(PedestalBlockEntity::method_5448);
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        return false;
    }

    public class_1799 method_5438(int slot) {
        if (slot > 8) {
            return class_1799.field_8037;
        }
        if (slot == 0) {
            return this.input.method_5438(0);
        }
        return this.catalysts[slot - 1].method_5438(0);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.method_5441(slot);
    }

    public class_1799 method_5441(int slot) {
        if (slot > 8) {
            return class_1799.field_8037;
        }
        if (slot == 0) {
            return this.input.method_5441(0);
        }
        return this.catalysts[slot - 1].method_5441(0);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot > 8) {
            return;
        }
        if (slot == 0) {
            this.input.method_5447(0, stack);
        } else {
            this.catalysts[slot - 1].method_5447(0, stack);
        }
    }

    public void method_5431() {
        if (this.isValid()) {
            this.input.method_5431();
            Arrays.stream(this.catalysts).forEach(PedestalBlockEntity::method_5431);
        }
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void fromTag(class_2487 tag) {
        if (tag.method_10545("recipe")) {
            this.hasRecipe = tag.method_10577("recipe");
            this.progress = tag.method_10550("progress");
            this.time = tag.method_10550("time");
        }
    }

    public class_2487 toTag(class_2487 tag) {
        if (this.hasRecipe()) {
            tag.method_10556("recipe", this.hasRecipe);
            tag.method_10569("progress", this.progress);
            tag.method_10569("time", this.time);
        }
        return tag;
    }

    public static Point[] getMap() {
        return PEDESTALS_MAP;
    }
}

